IF EXISTS ( SELECT * 
            FROM   sysobjects 
            WHERE  id = object_id(N'[dbo].[CP_Cbtes_Cpra_Generar_Fin]') 
                   and OBJECTPROPERTY(id, N'IsProcedure') = 1 )
BEGIN
    DROP PROCEDURE dbo.[CP_Cbtes_Cpra_Generar_Fin] 
END
GO


CREATE PROCEDURE [dbo].[CP_Cbtes_Cpra_Generar_Fin] 
@Id_Proveedor	INT,
@Destinatario	VARCHAR(100), 
@Importe	DECIMAL(12,2), 
@Id_Sucursal	SMALLINT,
@Fecha	DATETIME, 
@Id_Tipo_Cbte	CHAR(4),
@Lote	CHAR(14),
@Id_Estado_Cbte INT,
@Id_Cond_Pago	SMALLINT,
@Comprobante_Nro INT,
@Id_Trans Int

AS 

SET NOCOUNT ON 
BEGIN TRAN

PRINT 'Genero Comprobante Tipo: '+@Id_Tipo_Cbte+' para el Proveedor: '+CONVERT(VARCHAR(20),@Id_Proveedor)
PRINT 'Fecha del Comprobante: '+CONVERT(VARCHAR(20), @Fecha, 101)+' Estado Comprobante: '+CONVERT(VARCHAR(3),@id_Estado_Cbte)

/*Declaracion Variables Locales*/
DECLARE @User	SMALLINT
DECLARE @Desc	VARCHAR(50)
DECLARE @Nombre	VARCHAR(100)
DECLARE @Descripcion_Producto	VARCHAR(100)
DECLARE @Cantidad	DECIMAL(12,2)
DECLARE @Fecha_Mov	DATETIME
DECLARE @Fecha_Vence	DATETIME
DECLARE @Descrip_Cbte_CtaCte	VARCHAR(100)
DECLARE @Signo	INT
DECLARE @ImporteXCant	DECIMAL(12,2)
DECLARE	@Observacion	VARCHAR(30)
DECLARE @Compromete_Compras	SMALLINT
	,@IMP_GRAVADO DECIMAL(12,2)
	,@IMP_IVA DECIMAL(12,2)

/*FIN Declaracion Variables Locales*/

DECLARE @Mensaje			VARCHAR(100),@Id_Trans_ND INT

BEGIN TRY
BEGIN TRAN




/*Asignacion Variables*/
SET @Desc	= @Lote
SET @Observacion	= 'Comprobante Generado desde B.D.'
SET @Compromete_Compras	= ISNULL((SELECT Compromete_Compras FROM Cbtes_Tipos WHERE Id_Tipo_Cbte=@Id_Tipo_Cbte), 0)
SET @Fecha_Vence = ISNULL((SELECT Fecha_Venc FROM CBTES WHERE Id_Trans = @Id_Trans), @Fecha)
/*FIN Asignacion Variables*/


SET @Signo = @Compromete_Compras

/*---------------------------------------------------------------------------------*/

/*Update: CBTES*/
SET @ImporteXCant = (@Importe)

PRINT 'Modifico Cbtes'

UPDATE Cbtes SET 
Imp_Exento = 0, Imp_Gravado = 0, Imp_Gravado2 = 0, Imp_Gravado3 = 0, Imp_NoGravado = 0,
Imp_iva = 0, Imp_iva2 = 0, Imp_iva3 = 0,Imp_neto = 0, Saldo = 0, Imp_Total = 0 
WHERE ID_TRANS = @ID_TRANS 

UPDATE Cbtes SET 
Imp_Gravado = ISNULL((SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE ID_TRANS = @ID_TRANS and isnull(Porc_Iva,21) = 21),0) 
WHERE ID_TRANS = @ID_TRANS 
UPDATE Cbtes SET 
Imp_Iva = Imp_Gravado * Porc_Iva/100 
WHERE ID_TRANS = @ID_TRANS 

UPDATE Cbtes SET 
Imp_Gravado2 = ISNULL((SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE ID_TRANS = @ID_TRANS and isnull(Porc_Iva,21) = 10.5),0) 
WHERE ID_TRANS = @ID_TRANS 
UPDATE Cbtes SET 
Imp_Iva2 = Imp_Gravado2 * Porc_Iva2/100 
WHERE ID_TRANS = @ID_TRANS 

UPDATE Cbtes SET 
Imp_Gravado3 = ISNULL((SELECT SUM(Imp_Gravado) FROM Cbtes_Items WHERE ID_TRANS = @ID_TRANS and isnull(Porc_Iva,21) = 0),0) 
WHERE ID_TRANS = @ID_TRANS 
UPDATE Cbtes SET 
Imp_Iva3 = Imp_Gravado3 * Porc_Iva3/100 
WHERE ID_TRANS = @ID_TRANS 

UPDATE Cbtes SET 
Imp_TOTAL = Imp_Gravado + Imp_Gravado2 + Imp_Gravado3 + Imp_Iva + Imp_Iva2 + Imp_Iva3,
Saldo = Imp_Gravado + Imp_Gravado2 + Imp_Gravado3 + Imp_Iva + Imp_Iva2 + Imp_Iva3
WHERE ID_TRANS = @ID_TRANS 

SET @Importe = (SELECT Imp_TOTAL FROM Cbtes WHERE ID_TRANS = @ID_TRANS) 

/*---------------------------------------------------------------------------------*/
/*Insert: Clientes_CtaCte*/	
IF @Id_Cond_Pago <> 1
	BEGIN	
	SET @Descrip_Cbte_CtaCte = (
	ISNULL((SELECT Descrip_Corta FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte), ' ')+
	' ' +
	ISNULL((SELECT Letra FROM Cbtes_Tipos WHERE Id_Tipo_Cbte = @Id_Tipo_Cbte),'A') +
	' ' +
	RIGHT('0000' + LTRIM(RTRIM(@Id_Sucursal)),4) +
	'-' +
	RIGHT('00000000' + LTRIM(RTRIM(@Comprobante_Nro)),8)
	)
	PRINT 'Inserto en Proveedores_CtaCte Comprobante: ' + @Descrip_Cbte_CtaCte

	INSERT INTO Proveedores_CtaCte	(Id_Trans,	Nro_Cuota,	Id_Empresa,
	Id_Proveedor,	Fecha,	Fecha_Vence,
	Descripcion,	Importe,	Id_Estado_Cbte,
	Observacion,	Id_Trans_Origen,	Nro_Cuota_Origen,
	Id_Moneda,	Saldo)
	VALUES	(@Id_Trans,	1,	NULL,
	@Id_Proveedor,	@Fecha,	@Fecha_Vence,
	@Descrip_Cbte_CtaCte,@Importe,	@Id_Estado_Cbte,
	@Observacion,	0,	0,
	'PES',	@Importe)
	END

/*---------------------------------------------------------------------------------*/
--Insert: CBTES_CONCEPTOS/	
DECLARE @Id_Concepto INT
SET @Id_Concepto = (SELECT ISNULL(ID_CONCEPTO,0) FROM PROVEEDORES WHERE ID_PROVEEDOR = @Id_Proveedor)
IF @Id_Concepto > 0
	BEGIN
	INSERT INTO CBTES_CONCEPTOS (Id_Concepto, Id_Trans, Item, Importe, Observacion)
	VALUES	(@Id_Concepto,@Id_Trans,	1,@Importe,'')	
	END	 


/*---------------------------------------------------------------------------------*/
--Asiento

EXEC CP_Cbtes_Cpra_Generar_Asi @Id_Trans



COMMIT
SELECT	 0					AS ErrorNumber 
		,0					AS ErrorSeverity  
		,0					AS ErrorState 
		,0					AS ErrorProcedure  
		,0					AS ErrorLine		
		,@Mensaje			AS ErrorMessage

END TRY  


BEGIN CATCH  
    EXECUTE usp_GetErrorInfo;  
	ROLLBACK
END CATCH;   
